/*
	logic.js
	JavaScript game logic for Classic Memory
	Version 1.1 / august 2005
	
	Patrick Machielse (c) 2005
	Hieper Software
*/

//	----------------------------------------------------------------------
//	MAIN
//	----------------------------------------------------------------------

function main() {
	var game = new Game();
	
	//	create images in DOM and add cards to game
	for ( var i = 0; i < Game.CUT; i++ ) {
		var img = document.createElement("img");
		img.className = "card";
		getCards().appendChild(img);	
		game.addCard(img);
	}
	
	//	init game
	game.onstatechange = gameStateHandler;
	game.reset();
	window.game = game;
	
	//	add shaded accessor to widget window
	getWindow().isShaded = false;

	//	set event handlers
	window.onfocus			= focus;
	window.onblur			= blur;
	getFront().onmousemove	= mousemove;
	getFront().onmouseout	= mouseexit;
	getFlip().onclick		= showBack;
	getFlip().onmouseover	= enterflip;
	getFlip().onmouseout	= exitflip;
	getAbout().onclick		= hideBack;
	getWindow().onload		= windowDidLoad;
	getShader().ondblclick	= toggleShade;
	getMailer().onclick		= sendMail;
	
	//	load images
	getWindow().src			= NORMAL;
	getShadeBox().src		= SHADEBOX;
	getResetButton().src	= RESET;
	
	//	make controls
	makeAnimated(getArrows(), [ARROW0, ARROW1], 100);
	makeControl(getShadeBox(), toggleShade, SHADINGBOX);
	makeControl(getResetButton(), resetGame, RESETTING);
}
	
//	----------------------------------------------------------------------
//	GAME
//	----------------------------------------------------------------------

//	handle game progress (feedback)
function gameStateHandler(game) {
	var info, score = "";
	
	//	determine texts
	if ( game.isSolved() ) {
		info  = "Game solved in " + game.turns() + " turns. " +
				"Press 'Reset' to play again.";
	} else if ( game.tries == 0 ) {		//	not yet started
		info  = "Click on a card to start playing."
	} else if ( game.found == 0 ) {		//	started but nothing found yet
		info  = "Turn " + game.turns();
		score = "Nothing found yet";
	} else {							//	started and found pairs
		info  = "Turn " + game.turns();
		score = game.found + " pair" + (game.found == 1 ? "" : "s") + " found";
	}
		
	//	set texts
	setInfoText(info);
	setScoreText(score); 
}

//	restart the game
function resetGame() {
	getArrows().start();
	setTimeout(function () { window.game.reset(); getArrows().stop(); }, 400);
}
	
//	----------------------------------------------------------------------
//	EVENT HANDLERS
//	----------------------------------------------------------------------

//	window got focus
function focus() {
	//	set window style to active and show shade box
	getWindow().src = getWindow().isShaded ? SHADED : NORMAL;
	getShadeBox().show(true);
}

//	window lost focus
function blur() {
	//	set window style to inactive and hide shade box
	getWindow().src = getWindow().isShaded ? SHADED_NOFOCUS : NORMAL_NOFOCUS;
	getShadeBox().show(false);
}

//	window shade was triggered
function toggleShade() {
	var theWindow = getWindow();
	
	//	hide / show controls
	getContents().style.display = theWindow.isShaded ? "block" : "none";
	
	//	set window image
	theWindow.src = theWindow.isShaded ? NORMAL : SHADED;
	theWindow.isShaded = !theWindow.isShaded;
}

//	background image loaded
function windowDidLoad(event) {
	window.resizeTo(this.width, this.height);
}

function showBack(event)
{
    if ( window.widget )
        widget.prepareForTransition("ToBack");
                
    getFront().style.display="none";
    getBack().style.display="block";
    exitflip(event);
        
    if ( window.widget )
        setTimeout ('widget.performTransition();', 0);  
}

function hideBack(event)
{
    if ( window.widget )
        widget.prepareForTransition("ToFront");
                
    getBack().style.display="none";
    getFront().style.display="block";
        
    if ( window.widget )
        setTimeout ('widget.performTransition();', 0);
}

function sendMail(event)
{
	if ( window.widget ) widget.openURL(FEEDBACK_URL);	
}
